﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Delete
{
    /// <summary>
    /// Get Integration Settings step.
    /// </summary>
    public class GetIntegrationSettingsStep : FilterBase<VirtualMeetingRoomDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomDeleteStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                state.SchemaPath = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Schema Path").mcs_value;

                var useFakeResponse = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Use Fake Response").mcs_value;
                state.UseFakeResponse = Convert.ToBoolean(useFakeResponse);
            }
        }
    }
}